**************************************************************************************************
*******************"ADOPTION OF GPT" PAPER - EVENT STUDIES****************************************
*************************DATE: OCT 2023 **********************************************************
************************ AUTHOR: KIM NGUYEN AND JONATHAN HAMBUR **********************************
**************************************************************************************************

//LOAD DATA
use "Final_data.dta", clear

egen gics_y = group(gics_sector fy)

** Table 1
tabstat roa revenuefy assets cashratio debt gearingratiopreferred if gentech_iy_m==1 & fy==2022 & sector!="IT", stats(median n)
tabstat roa revenuefy assets cashratio debt gearingratiopreferred if gentech_iy_m==0 & fy==2022 & sector!="IT", stats(median n)


** Table 2
tabstat gentech_pcbi stem_pcbi mba_pcbi female_pcbi it_ind_pcbi age_pcb if gentech_iy_m==1 & fy==2022 & sector!="IT", stats(mean n)
tabstat gentech_pcbi stem_pcbi mba_pcbi female_pcbi it_ind_pcbi age_pcb if gentech_iy_m==0 & fy==2022 & sector!="IT", stats(mean n)

** Table 3
xtset id fy
areg gentech_iy_m l2.logasset l2.roa l2.pos_cf l2.c.cashratio l2.labourshare age if fy>=2013 & sector!="IT", a(gics_y)  cluster(id) 


** Table 4
areg gentech_by22 gentech_pcbi female_pcbi stem_pcbi mba_pcbi it_ind_pcbi if fy==2022 & sector!="IT", a(gics_sector)  cluster(gics_sector)
areg gentech_by22 gentech_pcbi female_pcbi stem_pcbi mba_pcbi it_ind_pcbi logassets if fy==2022 & sector!="IT", a(gics_sector) cluster(gics_sector)

** Table 5

preserve
xtset id fy
g l2logassets = l2.logassets
collapse(max) l2logasset ever_h_tech ever_cl ever_ml ever_tech gics_sector, by(asxcode)


reg  ever_h_tech ever_tech  if gics_sector != 45, vce(cluster gics_sector)
areg  ever_h_tech ever_tech  if gics_sector != 45, a(gics_sector) cluster(gics_sector)
areg  ever_h_tech ever_tech l2logassets if gics_sector != 45, a(gics_sector) cluster(gics_sector)
 
restore


** Table B1
tabstat roa revenuefy assets cashfy debt gearingratiopreferred if (gentech_iy_m==1 | gentech_iy_m ==0) & lateadopters==2 & sector!="IT"  , stats(median n)
tabstat roa revenuefy assets cashfy debt gearingratiopreferred if (gentech_iy_m==1 | gentech_iy_m ==0) & lateadopters==1 & sector!="IT"  , stats(median n)


** Table C2
xtset id fy

probit gentech_iy_m l2.logasset l2.roa l2.pos_cf l2.c.cashratio l2.labourshare age i.gics_y if fy>=2013 & sector!="IT", cluster(id)


** Table C3

** Create deciles
foreach var in  logasset  {
    egen dec_y_`var' = xtile(`var'), by(fy) n(10)
    egen dec_yi_`var' = xtile(`var'), by(gics_y)  n(10)
}
** Decile regression
foreach var in logasset {
     areg gentech_iy_m l2.i.dec_yi_`var' if fy>=2013  & sector!="IT", a(gics_y)  cluster(id) 
}
